/******************************************************************************
 CAdaGenTask.h

			Source File For CAdaGenTask Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	by Manuel A. Perez

 ******************************************************************************/

#include "CAdaGenTask.h"
#include "CAdaApp.h"
#include "CSourceDocument.h"
#include "CLibrary.h"
#include "AdaGlobals.h"
#include "AdaConstants.h"
#include "CFileMgr.h"

#include <CBartender.h>
#include <TBUtilities.h>
#include <Exceptions.h>
#include <stdio.h>
#include <stdlib.h>
#include "ErrMessages.h"
#include "FileNames.h"

#include "Announce.h"

extern	CApplication *gApplication;	/* The application */
extern	OSType	gSignature;			/* Creator for Application's files	*/
extern CBartender	*gBartender;		/* Manages all menus				*/


/****
 *	IAdaGenTask
 *
 ****/
void	CAdaGenTask::IAdaGenTask(CSourceDocument *doc)
{
	Str255	n;

	GetIndString(n, 20020, 2);
	ICompileTask(doc, n);
	SetPartID(kGen);
}

/****
 *	WriteOptions
 *
 ****/

void	CAdaGenTask::WriteOptions(void)
{
Str255 file;
FILE *fp;

	// Write adagen compile options to disk
	gFileMgr->GetOptionsFile(file);
	PtoCstr(file);

	_fcreator = gSignature;
	if (fp = fopen((char *)file, "w")) {
		Str255 fileName, justTheName;
	
		// Process name (adagen)
		fprintf(fp, "%#s\n", procName);

		// Get User Library
		gLibrary->WriteOptions(fp);

		// option (-g l) to use all the time (equivalent to -a in adacomp)
		fprintf(fp, "-g\nl\n");

		// Source File to Compile
		itsDoc->GetFileName(fileName);
		ParseFile(fileName, flName, justTheName);

		fprintf(fp, "%#s\n", justTheName);
		fclose(fp);
	}
	else {
		// Fail opening adagen options
		Failure(errWritingOptions, 0);
	}
}

/****
 *	NoError()
 *
 *	If we finish this step without any errors, then update
 *	the library, close the document (if needed) and/or
 *	open the listing file.
 *
 ****/

void	CAdaGenTask::NoError(void)
{
	MenuHandle menu;
	Boolean mustOpenListing;
	Boolean compileOnly;
	Str255 str;


	CreateListing();

	GetIndString(str, 20030, 1);	// Get String Compiling
	ParamText(str, NULL, NULL, NULL);
	gAdaApp->FinishedBkgnd(20020, true);
/**	NoteAlert(20020, NULL);	**/		// Finished Successfully

	gAdaApp->GetOptions(&mustOpenListing);
	compileOnly = itsDoc->IsItCompileOnly();

	// if the file was compile only, then close it
	if (compileOnly)
		itsDoc->Close(false);

	// else if file was not compile only but we must
	// open the listing (even if no errors are found)
	// then call ProcessError() - this will open the
	// listing file.
	else if (mustOpenListing) {
		itsDoc->OpenListing();
	}

	//... and update the library display
	gLibrary->LibraryChanged();
	menu = gBartender->FindMacMenu(kBindOtherMenu);
	gLibrary->BuildBindMenu(menu);

	menu = gBartender->FindMacMenu(kExecuteOtherMenu);
	gLibrary->BuildExecuteMenu(menu);

}
